#include <stdio.h>
#include <stdlib.h>
#include "oz_pedissector_structs.h"

void dump_word(DWORD w){
	int i;
	unsigned char tmp;
	for (i=0;i<4;i++){
		tmp = (w&(255<<i*8))>>(i*8);
		printf("[%c]",tmp);
	}
	printf("\t0x");
	for (i=3;i>=0;i--){
		tmp = (w&(255<<i*8))>>(i*8);
		printf("%02x",tmp);
	}
	printf("\t");
	printf("%d",(unsigned int)w);
}

void dump_size(){
	printf("SIZEOF IMAGE_DOS_HEADER : %ld\n",sizeof(IMAGE_DOS_HEADER));
	printf("SIZEOF IMAGE_NT_HEADERS : %ld\n",sizeof(IMAGE_NT_HEADERS));
	printf("SIZEOF IMAGE_SECTION_HEADER : %ld\n",sizeof(IMAGE_SECTION_HEADER));

}
char* section_name_to_str(IMAGE_SECTION_HEADER hdr){
	char* res= malloc(sizeof(char)*9);
	int i;
	for (i=0; i<8;i++){
		if (hdr.Name[i]!='\0') {
			res[i] = hdr.Name[i];
		} else {
			res[i]='\0';
		}
	}
	res[8] = '\0';
	return res;
}

long rva2offset(IMAGE_NT_HEADERS NT_hdr, IMAGE_SECTION_HEADER* SECTIONS_hdr, unsigned long rva) {
	unsigned int nb_s = NT_hdr.FileHeader.NumberOfSections;
	unsigned int i;
	for(i=0;i<nb_s;i++) {
		if ((rva>=SECTIONS_hdr[i].VirtualAddress) && (rva<=SECTIONS_hdr[i].VirtualAddress+SECTIONS_hdr[i].SizeOfRawData)) //I know, I shall use VirtualSize
		{
			//Good section found
			unsigned long section_offset = rva-SECTIONS_hdr[i].VirtualAddress;
			return SECTIONS_hdr[i].PointerToRawData + section_offset;
			
		}
	}
	return -1;
}

int main(int argc, char** argv) {
	if (argc<2){
		printf("Usage : %s FILENAME\r\n",argv[0]);
		return EXIT_FAILURE;
	}
	dump_size();

	printf("Opening file : %s\r\n",argv[1]);
	FILE* f = fopen(argv[1],"rb");

	// *********************
	//	DOS HEADER
	// *********************

	IMAGE_DOS_HEADER DOS_HEADER;
	fread(&DOS_HEADER, sizeof(IMAGE_DOS_HEADER), 1, f);
	printf("CHECK DOS MAGIC: ");
	dump_word(DOS_HEADER.e_magic);
	printf("\n");
	printf("ZONE : IMAGE_DOS_HEADER\tEn-tete DOS\t0\t%ld\r\n",sizeof(IMAGE_DOS_HEADER));

	printf("NT_HEADERS start : ");
	dump_word(DOS_HEADER.e_lfanew);
	printf("\n");

	// *********************
	//	NT HEADER
	// *********************

	IMAGE_NT_HEADERS NT_HEADERS;
	fseek(f, (long)DOS_HEADER.e_lfanew, SEEK_SET);
	fread(&NT_HEADERS, sizeof(IMAGE_NT_HEADERS), 1, f);
	printf("CHECK NT MAGIC : ");
	dump_word(NT_HEADERS.Signature);
	printf("\n");
	printf("ZONE : IMAGE_NT_HEADERS\tEn-tete NT\t%lu\t%lu\r\n",DOS_HEADER.e_lfanew, DOS_HEADER.e_lfanew+sizeof(IMAGE_NT_HEADERS));

	printf("NUMBER OF SECTIONS : %d\r\n",NT_HEADERS.FileHeader.NumberOfSections);


	// ************************
	//	SECTIONS (+HEADER)
	// ************************

	IMAGE_SECTION_HEADER* SECTION_HEADERS;
	SECTION_HEADERS = malloc(sizeof(IMAGE_SECTION_HEADER)*NT_HEADERS.FileHeader.NumberOfSections);
	int i;
	for (i=0;i<NT_HEADERS.FileHeader.NumberOfSections;i++){
		fread( &(SECTION_HEADERS[i]), sizeof(IMAGE_SECTION_HEADER), 1, f);
		int j;
		printf("HEADER OK FOR SECTION %d : \"",i);
		for (j=0;j<8;j++) {
			printf("%c",SECTION_HEADERS[i].Name[j]);
		}
		printf("\"\r\n");
		char* s_name = section_name_to_str(SECTION_HEADERS[i]);
		printf("ZONE : SECTION_HEADERS[%d]\tEn tete de section \"%s\"\t%lu\t%lu\r\n",i,s_name, 
			DOS_HEADER.e_lfanew+sizeof(IMAGE_NT_HEADERS)+ i*sizeof(IMAGE_SECTION_HEADER), 
			DOS_HEADER.e_lfanew+sizeof(IMAGE_NT_HEADERS)+ (i+1)*sizeof(IMAGE_SECTION_HEADER) 
		);
		printf("ZONE : SECTION[%d]\tContenu de section \"%s\"\t%lu\t%lu\r\n",i, s_name, 
			SECTION_HEADERS[i].PointerToRawData,
			SECTION_HEADERS[i].PointerToRawData+SECTION_HEADERS[i].SizeOfRawData
		);
		free(s_name);
	}

	// *********************
	//	DATA DIRECTORY
	// *********************

	char* names[] = {
		"Export Symbols",
		"Import Symbols",
		"Resources",
		"Exception",
		"Security",
		"Base relocation",
		"Debug",
		"Copyright string",
		"Unknown...",
		"Thread Local Storage (TLS)",
		"Load Configuration",
		"Bount Import",
		"Import Address Table",
		"Delay Import",
		"COM descriptor",
		"_Reserved_"
	};
	for (i=0; i<16; i++) {
		if (NT_HEADERS.OptionalHeader.DataDirectory[i].VirtualAddress >0) {
			unsigned long offset = rva2offset(NT_HEADERS, SECTION_HEADERS, NT_HEADERS.OptionalHeader.DataDirectory[i].VirtualAddress);
			printf("ZONE : DATA_DIRECTORY[%d]\t%s\t%ld\t%ld\r\n",i,names[i],
				offset,
				offset+NT_HEADERS.OptionalHeader.DataDirectory[i].Size
			);
		}
	}

	// *********************
	//	IMPORT TABLE
	// *********************
	IMAGE_IMPORT_DESCRIPTOR import_descriptor;
	import_descriptor.Name=666;
	unsigned short dll_id=0;
	while (import_descriptor.Name!=0){
		DWORD addr_struct = NT_HEADERS.OptionalHeader.DataDirectory[1].VirtualAddress+sizeof(IMAGE_IMPORT_DESCRIPTOR)*dll_id;
		//printf("Addr Struct (rva) : "); dump_word(addr_struct); printf("\r\n");
		addr_struct = rva2offset(NT_HEADERS, SECTION_HEADERS, addr_struct);
		//printf("Addr Struct (offset) : "); dump_word(addr_struct); printf("\r\n");
		fseek(f, (long)addr_struct, SEEK_SET);
		fread(&import_descriptor, sizeof(IMAGE_IMPORT_DESCRIPTOR), 1, f);
		
		printf("ZONE : IMPORT_DESCRIPTOR[%d]\tN/A\t%ld\t%ld\r\n",dll_id,
				addr_struct,
				addr_struct+sizeof(IMAGE_IMPORT_DESCRIPTOR)
			);


		// Strings containing the DLL names
		if (import_descriptor.Name!=0) {
			DWORD addr_name = rva2offset(NT_HEADERS, SECTION_HEADERS,  import_descriptor.Name);
			char tmp;
			tmp='_';
			i=0; //safeguard
			printf("ZONE : Import DLL Name[%d]\t",dll_id);
			while ((tmp!='\0')&&(i<20)) {
				fseek(f, addr_name+i, SEEK_SET);
				fread(&tmp, sizeof(char), 1, f);
				if (tmp!='\0')
					printf("%c",tmp);
				i++;
			}
			printf("\t%ld\t%ld\r\n",
				addr_name,
				addr_name+sizeof(char)*i
			);
			//dll_id++;
		}
		// RVA array pointed by OriginalFirstThunk
		if (import_descriptor.OriginalFirstThunk!=0) {
			DWORD addr_array = rva2offset(NT_HEADERS, SECTION_HEADERS,  import_descriptor.OriginalFirstThunk);
			DWORD tmp;
			tmp=1;
			i=0; //safeguard
			while ((tmp!=0)&&(i<200)) {
				fseek(f, addr_array+i*sizeof(DWORD), SEEK_SET);
				fread(&tmp, sizeof(DWORD), 1, f);
				i++;
				// IMAGE_IMPORT_BY_NAME structure
				IMAGE_IMPORT_BY_NAME pointed;
				DWORD addr_struct = rva2offset(NT_HEADERS, SECTION_HEADERS,  tmp);
				fseek(f, addr_struct, SEEK_SET);
				fread(&pointed, sizeof(IMAGE_IMPORT_BY_NAME), 1, f);
				int k=0;
				char tmp_char;
				fseek(f, addr_struct+sizeof(WORD), SEEK_SET);
				fread(&tmp_char, sizeof(char), 1, f);
				if (tmp_char!='\0') {
					printf("ZONE : Function Name[%d] pointed by OriginalFirstThunk[%d]\t",i,dll_id);
					while((tmp_char!='\0') && (k<200)) {
						//printf("Function first letter : %c\n",pointed.Name);
						fseek(f, addr_struct+sizeof(WORD)+k, SEEK_SET);
						fread(&tmp_char, sizeof(char), 1, f);
						if (tmp_char!='\0')
							printf("%c",tmp_char);
						k++;
					}
					printf("\t%ld\t%ld\r\n",addr_struct+sizeof(WORD), addr_struct+sizeof(WORD)+k);
				}
			}
			printf("ZONE : ARRAY pointed by OriginalFirstThunk[%d]\tN/A\t%ld\t%ld\r\n",dll_id,
				addr_array,
				addr_array+sizeof(DWORD)*(i-1)
			);
		}
		// RVA array pointed by FirstThunk
		if (import_descriptor.FirstThunk!=0) {
			DWORD addr_array = rva2offset(NT_HEADERS, SECTION_HEADERS,  import_descriptor.FirstThunk);
			DWORD tmp;
			tmp=1;
			i=0; //safeguard
			while ((tmp!=0)&&(i<200)) {
				fseek(f, addr_array+i*sizeof(DWORD), SEEK_SET);
				fread(&tmp, sizeof(DWORD), 1, f);
				i++;
			}
			printf("ZONE : ARRAY pointed by FirstThunk[%d]\tN/A\t%ld\t%ld\r\n",dll_id,
				addr_array,
				addr_array+sizeof(DWORD)*(i-1)
			);
		}
		dll_id++;
	}

	fclose(f);
	return EXIT_SUCCESS;
}
