import os, sys, tempfile, random, logging
from PIL import Image, ImageDraw, ImageFont


def give_rand_color():
	fill = (random.randint(30,255) , random.randint(30,255), random.randint(30,255))
	if max(fill)>160:
		outline = (fill[0]/2, fill[1]/2, fill[2]/2)
	else:
		outline = ( min(255,fill[0]*2), min(255,fill[1]*2), min(255,fill[1]*2) )
	return fill, outline

class zone:
	def __init__(self, name, start, end, comment):
		self.nested_level = 0
		self.name = name
		self.start = start
		self.end = end
		self.comment = comment
		fill, outline = give_rand_color()
		self.fill = fill
		self.outline = outline

	def update_nested_level(self, zones):
		nested = 0
		for z in zones:
			if z!=self and (z.start<= self.start) and (z.end >= self.end):
				nested+=1
		self.nested_level=nested
	def __str__(self):
		return self.name+'['+hex(self.start)+','+hex(self.end)+']'
			
		
class ozmap:
	def __init__(self, min_size):
		self.img  = Image.new("RGB",(600,1),(0,0,0))
		self.w = 600
		self.h = 1
		self.zones= []
		self.min_size = min_size		
	def add_zone(self, z):
		if z.end-z.start>=self.min_size:
			self.zones.append(z)
		else:
			logging.error("Skipping zone %s because smaller than min_size %d"%(str(z),self.min_size))
	def svg(self, svg_file="oz_pedissector.svg"):
		"""
		Writes SVG file
		"""
		svg = open(svg_file,'w')
		svg.write('<?xml version="1.0" encoding="utf-8"?><svg xmlns="http://www.w3.org/2000/svg" version="1.1">')

		max_addr = max([z.end for z in self.zones])
		current_zones = []
		current_y = 0
		padded = False
		for cur_addr in range(max_addr+2): # the "+2" is there to ensure we close ALL zones in the main loop :)
			new_ones=[]
			# We check if we shall add a new current zone
			for z in self.zones:
				if (cur_addr>=z.start) and (cur_addr<=z.end) and (not z in current_zones):
					current_zones.append(z)
					z.svg_start = current_y
					#current_y+=30 #we need at least 30 pixels for displaying a zone correctly
					new_ones.append(z)
					padded=False
			if new_ones!=[]:
				current_y+=30
			# We check if we left a current zone
			to_remove=[]
			for z in current_zones:
				if (cur_addr>=z.end):
					z.svg_end = current_y-30
					H = z.svg_end - z.svg_start
					fill, outline = give_rand_color()
					fill = '#%02x%02x%02x'%(fill[0],fill[1],fill[2])
					svg.write("\n"+'<rect width="560" height="%d" x="%d" y="%d" fill="#EEEEEE" stroke="#000000" />'%(H, 600*z.nested_level, z.svg_start))
					svg.write("\n")
					svg.write('<rect width="40" height="%d" x="%d" y="%d" fill="%s" stroke="#000000" />'%(H, 600*z.nested_level+560, z.svg_start, fill))
					svg.write("\n")
					svg.write('<text x="%d" y="%d" font-size="20">%s</text>'%(600*z.nested_level, z.svg_start+(H/2)+5, z.name+'('+z.comment+')') )
					svg.write("\n")
					svg.write('<text x="%d" y="%d" font-size="12">%s</text>'%(600*z.nested_level+500, z.svg_start+12, hex(z.start) ) )
					svg.write("\n")
					svg.write('<text x="%d" y="%d" font-size="12">%s</text>'%(600*z.nested_level+500, z.svg_end-2, hex(z.end) ) )
					svg.write("\n\n")
					padded=False
					to_remove.append(z)
			for z in to_remove:
				current_zones.remove(z)
			if new_ones==[] and padded==False:
				# There was no new section, we insert a padding
				#and set "padded" to true so that we pas only once
				current_y+=30
				padded=True
		svg.write('</svg>')
		svg.close()

def dissect(filename):
	import re
	tmp = tempfile.NamedTemporaryFile()
	os.system("./a.out "+sys.argv[1]+" > "+tmp.name)
	execres = tmp.readlines()
	tmp.close()

	res=[]
	for l in execres:
		l = l.strip()
		
		if re.match("^ZONE :",l):
			logging.info("PE zone discovered [%s]",l)
			nom, comment, start, end = re.findall("^ZONE : (.*?)\t(.+?)\t(.+?)\t([^\r^\n]+)",l)[0]
			start = int(start)
			end = int(end)
			if start>-1:
				res.append(zone(nom, start, end, comment))
	return res

		
if __name__=='__main__':
	logging.basicConfig(level = logging.DEBUG)

	if len(sys.argv)<2:
		logging.critical("Usage : %s PEFILE.EXE [Minimum size for a structure to be drawn (in bytes)]"%sys.argv[0])
		sys.exit(0)

	zones = dissect(sys.argv[1])
	min_size = -1 #size under which structures are not rendered
	if len(sys.argv)>2:
		min_size = int(sys.argv[2])
	m = ozmap(min_size = min_size)
	for z in zones:
		z.update_nested_level(zones)
		logging.debug("Adding zone : %s [%d]"%(str(z),z.nested_level))
		m.add_zone(z)
	m.svg()
