import os, sys, tempfile, random, logging
from PIL import Image, ImageDraw, ImageFont


def give_rand_color():
	fill = (random.randint(30,255) , random.randint(30,255), random.randint(-30,255))
	if max(fill)>160:
		outline = (fill[0]/2, fill[1]/2, fill[2]/2)
	else:
		outline = ( min(255,fill[0]*2), min(255,fill[1]*2), min(255,fill[1]*2) )
	return fill, outline

class zone:
	def __init__(self, name, start, end, comment):
		self.nested_level = 0
		self.name = name
		self.start = start
		self.end = end
		self.comment = comment
		fill, outline = give_rand_color()
		self.fill = fill
		self.outline = outline
	def update_nested_level(self, zones):
		nested = 0
		for z in zones:
			if z!=self and (z.start<= self.start) and (z.end >= self.end):
				nested+=1
		self.nested_level=nested
	def __str__(self):
		return self.name+'['+hex(self.start)+','+hex(self.end)+']'
		
class ozmap:
	def __init__(self):
		self.img  = Image.new("RGB",(600,1),(0,0,0))
		self.w = 600
		self.h = 1
		self.zones= []				
	def add_zone(self, z):
		self.zones.append(z)
		if z.end > self.h:
			logging.info("Enlargement in H required")
			self.h = z.end
			new_im = Image.new("RGB",(self.w,self.h),(0,0,0))
			new_im.paste(self.img, (0,0))
			self.img = new_im
		if 600+z.nested_level*600>self.w:
			logging.info("Enlargement in W required")
			self.w = 600+z.nested_level*600
			new_im = Image.new("RGB",(self.w,self.h),(0,0,0))
			new_im.paste(self.img, (0,0))
			self.img = new_im

		draw = ImageDraw.Draw(self.img)
		
		big_font = ImageFont.truetype('/usr/share/fonts/truetype/culmus/HadasimCLM-Regular.ttf',18)
		tiny_font = ImageFont.truetype('/usr/share/fonts/truetype/culmus/HadasimCLM-Regular.ttf',14)
		#big_font = ImageFont.truetype('/usr/share/fonts/corefonts/times.ttf',18)
		#tiny_font = ImageFont.truetype('/usr/share/fonts/corefonts/times.ttf',14)

		draw.rectangle((0+z.nested_level*600,z.start,550+z.nested_level*600,z.end),fill=(50,50,50))
	
		W,H = big_font.getsize(z.comment)
		draw.text((0+z.nested_level*600,z.start+(z.end-z.start)/2-H/2),z.comment, font=big_font, fill="white")
		W,H = big_font.getsize(z.name)
		draw.text((200+z.nested_level*600,z.start+(z.end-z.start)/2-H/2),z.name, font=big_font, fill="white")
		draw.text((400+z.nested_level*600,z.start),'0x'+hex(z.start).upper()[2:], font=tiny_font, fill="white")
		W,H = tiny_font.getsize(z.comment)		
		draw.text((450+z.nested_level*600,z.end-H-1),'0x'+hex(z.end).upper()[2:], font=tiny_font, fill="white")

		draw.rectangle((550+z.nested_level*600,z.start,600+z.nested_level*600,z.end),fill=z.fill, outline=z.outline )
		for x in range(0+z.nested_level*600, self.w-10, 20):
			draw.rectangle((x,z.end-1,x+10,z.end),fill=z.fill)
		for x in range(0+z.nested_level*600, self.w-10, 20):
			draw.rectangle((x,z.start,x+10,z.start+1),fill=z.fill)
		del draw

	def compressor(self):
		"""
		Takes a natural raw img and "compress" it in the Y axis by
		deleting redondant pieces of information
		"""
		ref_line = [(0,0,0) for x in range(self.w)]
		res=[]
		repetition = 0
		logging.info("Compression started")
		progress = -1
		ellipsing = False
		for y in range(self.h):
			#cur_line = DATA[y*self.w : y*self.w+self.w]
			cur_line = [self.img.getpixel((x,y)) for x in range(0,self.w,20)] #only 20 by 20 pixels to speed up things
			if cur_line==ref_line:
				repetition+=1
			else:
				ref_line = cur_line
				repetition=0

			if repetition <30:
				ellipsing = False
				res.append(y)
			else:
				if ellipsing==False:
					res+=["ELLIPSE" for i in range(60)]
					ellipsing = True
			if (100*y)/self.h != progress:
				progress = (100*y)/self.h
				logging.info("Compression first pass %d%%",progress)
			sys.stdout.flush()
		logging.info("Compression first pass DONE.")
		new_H = len(res) - res.count('ELLIPSE')
		logging.debug("Original high %d, compressed (usefull) one %d"%(self.h, new_H))
		logging.debug("Original high %d, compressed (total) one %d"%(self.h, new_H+res.count('ELLIPSE')*30))
		img = Image.new("RGB",(self.w,len(res)),(0,0,0))
		logging.info("Compression second pass started.")
		progress=-1
		last_normal = -1
		for id_r in range(len(res)):
			if progress != (100*id_r)/len(res):
				progress = (100*id_r)/len(res)
				logging.info("Compression second pass %d%%",progress)

			if res[id_r]!="ELLIPSE":
				counter=0
				last_normal = res[id_r]
				for x in range(self.w):
					img.putpixel((x,id_r),self.img.getpixel((x,res[id_r])))
			if res[id_r]=="ELLIPSE":
				for X in range(self.w):
					if (X%100 in [0,1]) and (id_r%8 in [0,1,2]) and counter<30:
						img.putpixel((X,id_r),(255,255,255))
					else:
						img.putpixel((X,id_r),self.img.getpixel((X,last_normal)) )
				counter+=1
		logging.info("Compression second pass finished.")
		self.img_compressed = img
		
			
	def save(self, filename="oz_pedissector.png"):
		self.compressor()
		self.img.save(filename)
		self.img_compressed.save(filename+'_compressed_.png')

def dissect(filename):
	import re
	tmp = tempfile.NamedTemporaryFile()
	os.system("./a.out "+sys.argv[1]+" > "+tmp.name)
	execres = tmp.readlines()
	tmp.close()

	res=[]
	for l in execres:
		l = l.strip()
		
		if re.match("^ZONE :",l):
			logging.info("PE zone discovered [%s]",l)
			nom, comment, start, end = re.findall("^ZONE : (.*?)\t(.+?)\t(.+?)\t([^\r^\n]+)",l)[0]
			start = int(start)
			end = int(end)
			if start>-1:
				res.append(zone(nom, start, end, comment))
	return res

		
if __name__=='__main__':
	logging.basicConfig(level = logging.DEBUG)

	m = ozmap()
	zones = dissect(sys.argv[1])
	for z in zones:
		z.update_nested_level(zones)
		logging.debug("Adding zone : %s [%d]"%(str(z),z.nested_level))
		m.add_zone(z)
	m.save()
