#include <stdio.h>
#include <stdlib.h>
#include "oz_pedissector_structs.h"

void dump_word(WORD w){
	int i;
	unsigned char tmp;
	for (i=0;i<4;i++){
		tmp = (w&(255<<i*8))>>(i*8);
		printf("[%c]",tmp);
	}
	printf("\t0x");
	for (i=3;i>=0;i--){
		tmp = (w&(255<<i*8))>>(i*8);
		printf("%02x",tmp);
	}
	printf("\t");
	printf("%d",(unsigned int)w);
}

void dump_size(){
	printf("SIZEOF IMAGE_DOS_HEADER : %ld\n",sizeof(IMAGE_DOS_HEADER));
	printf("SIZEOF IMAGE_NT_HEADERS : %ld\n",sizeof(IMAGE_NT_HEADERS));
	printf("SIZEOF IMAGE_SECTION_HEADER : %ld\n",sizeof(IMAGE_SECTION_HEADER));

}
char* section_name_to_str(IMAGE_SECTION_HEADER hdr){
	char* res= malloc(sizeof(char)*9);
	int i;
	for (i=0; i<8;i++){
		if (hdr.Name[i]!='\0') {
			res[i] = hdr.Name[i];
		} else {
			res[i]='\0';
		}
	}
	res[8] = '\0';
	return res;
}

long rva2offset(IMAGE_NT_HEADERS NT_hdr, IMAGE_SECTION_HEADER* SECTIONS_hdr, unsigned long rva) {
	unsigned int nb_s = NT_hdr.FileHeader.NumberOfSections;
	unsigned int i;
	for(i=0;i<nb_s;i++) {
		if ((rva>=SECTIONS_hdr[i].VirtualAddress) && (rva<=SECTIONS_hdr[i].VirtualAddress+SECTIONS_hdr[i].SizeOfRawData)) //I know, I shall use VirtualSize
		{
			//Good section found
			unsigned long section_offset = rva-SECTIONS_hdr[i].VirtualAddress;
			return SECTIONS_hdr[i].PointerToRawData + section_offset;
			
		}
	}
	return -1;
}

int main(int argc, char** argv) {
	if (argc<2){
		printf("Usage : %s FILENAME\r\n",argv[0]);
		return EXIT_FAILURE;
	}
	dump_size();

	printf("Opening file : %s\r\n",argv[1]);
	FILE* f = fopen(argv[1],"rb");

	// *********************
	//	DOS HEADER
	// *********************

	IMAGE_DOS_HEADER DOS_HEADER;
	fread(&DOS_HEADER, sizeof(IMAGE_DOS_HEADER), 1, f);
	printf("CHECK DOS MAGIC: ");
	dump_word(DOS_HEADER.e_magic);
	printf("\n");
	printf("ZONE : IMAGE_DOS_HEADER\tEn-tete DOS\t0\t%ld\r\n",sizeof(IMAGE_DOS_HEADER));

	printf("NT_HEADERS start : ");
	dump_word(DOS_HEADER.e_lfanew);
	printf("\n");

	// *********************
	//	NT HEADER
	// *********************

	IMAGE_NT_HEADERS NT_HEADERS;
	fseek(f, (long)DOS_HEADER.e_lfanew, SEEK_SET);
	fread(&NT_HEADERS, sizeof(IMAGE_NT_HEADERS), 1, f);
	printf("CHECK NT MAGIC : ");
	dump_word(NT_HEADERS.Signature);
	printf("\n");
	printf("ZONE : IMAGE_NT_HEADERS\tEn-tete NT\t%lu\t%lu\r\n",DOS_HEADER.e_lfanew, DOS_HEADER.e_lfanew+sizeof(IMAGE_NT_HEADERS));

	printf("NUMBER OF SECTIONS : %d\r\n",NT_HEADERS.FileHeader.NumberOfSections);


	// ************************
	//	SECTIONS (+HEADER)
	// ************************

	IMAGE_SECTION_HEADER* SECTION_HEADERS;
	SECTION_HEADERS = malloc(sizeof(IMAGE_SECTION_HEADER)*NT_HEADERS.FileHeader.NumberOfSections);
	int i;
	for (i=0;i<NT_HEADERS.FileHeader.NumberOfSections;i++){
		fread( &(SECTION_HEADERS[i]), sizeof(IMAGE_SECTION_HEADER), 1, f);
		int j;
		printf("HEADER OK FOR SECTION %d : \"",i);
		for (j=0;j<8;j++) {
			printf("%c",SECTION_HEADERS[i].Name[j]);
		}
		printf("\"\r\n");
		char* s_name = section_name_to_str(SECTION_HEADERS[i]);
		printf("ZONE : SECTION_HEADERS[%d]\tEn tete de section \"%s\"\t%lu\t%lu\r\n",i,s_name, 
			DOS_HEADER.e_lfanew+sizeof(IMAGE_NT_HEADERS)+ i*sizeof(IMAGE_SECTION_HEADER), 
			DOS_HEADER.e_lfanew+sizeof(IMAGE_NT_HEADERS)+ (i+1)*sizeof(IMAGE_SECTION_HEADER) 
		);
		printf("ZONE : SECTION[%d]\tContenu de section \"%s\"\t%lu\t%lu\r\n",i, s_name, 
			SECTION_HEADERS[i].PointerToRawData,
			SECTION_HEADERS[i].PointerToRawData+SECTION_HEADERS[i].SizeOfRawData
		);
		free(s_name);
	}

	// *********************
	//	DATA DIRECTORY
	// *********************

	char* names[] = {
		"Export Symbols",
		"Import Symbols",
		"Resources",
		"Exception",
		"Security",
		"Base relocation",
		"Debug",
		"Copyright string",
		"Unknown...",
		"Thread Local Storage (TLS)",
		"Load Configuration",
		"Bount Import",
		"Import Address Table",
		"Delay Import",
		"COM descriptor",
		"_Reserved_"
	};
	for (i=0; i<16; i++) {
		if (NT_HEADERS.OptionalHeader.DataDirectory[i].VirtualAddress >0) {
			unsigned long offset = rva2offset(NT_HEADERS, SECTION_HEADERS, NT_HEADERS.OptionalHeader.DataDirectory[i].VirtualAddress);
			printf("ZONE : DATA_DIRECTORY[%d]\t%s\t%ld\t%ld\r\n",i,names[i],
				offset,
				offset+NT_HEADERS.OptionalHeader.DataDirectory[i].Size
			);
		}
	}


	fclose(f);
	return EXIT_SUCCESS;
}
